/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import filenet.pe.peorb.FileNet_PERPC.ApplicationSpaceInfo;
import filenet.pe.peorb.FileNet_PERPC.ConfigHdrResult;
import filenet.pe.peorb.FileNet_PERPC.ConfigHdrStruct;
import filenet.pe.peorb.FileNet_PERPC.ConfigInfo;
import filenet.pe.peorb.FileNet_PERPC.ConfigResult;
import filenet.pe.peorb.FileNet_PERPC.DBConnection;
import filenet.pe.peorb.FileNet_PERPC.EnvironmentData;
import filenet.pe.peorb.FileNet_PERPC.ExposedFieldDefinition;
import filenet.pe.peorb.FileNet_PERPC.FValue;
import filenet.pe.peorb.FileNet_PERPC.Field;
import filenet.pe.peorb.FileNet_PERPC.FieldType;
import filenet.pe.peorb.FileNet_PERPC.IndexDefinition;
import filenet.pe.peorb.FileNet_PERPC.LogDefinition;
import filenet.pe.peorb.FileNet_PERPC.MileStoneDefinition;
import filenet.pe.peorb.FileNet_PERPC.OperationDefinition;
import filenet.pe.peorb.FileNet_PERPC.ParticipantStruct;
import filenet.pe.peorb.FileNet_PERPC.QueryResult;
import filenet.pe.peorb.FileNet_PERPC.QueueDefinition;
import filenet.pe.peorb.FileNet_PERPC.Role;
import filenet.pe.peorb.FileNet_PERPC.RoleDefinitionInfo;
import filenet.pe.peorb.FileNet_PERPC.RosterDefinition;
import filenet.pe.peorb.FileNet_PERPC.SingleValue;
import filenet.pe.peorb.FileNet_PERPC.StepProcessorInfo;
import filenet.pe.peorb.FileNet_PERPC.StringAndFValue;
import filenet.pe.peorb.FileNet_PERPC.StringAndLong;
import filenet.pe.peorb.FileNet_PERPC.SystemConfigInfo;
import filenet.pe.peorb.FileNet_PERPC.WorkBasket;
import filenet.pe.peorb.FileNet_PERPC.WorkBasketColumnDefinition;
import filenet.pe.peorb.FileNet_PERPC.WorkBasketDefinition;
import filenet.pe.peorb.FileNet_PERPC.WorkBasketFilterDefinition;
import filenet.pe.peorb.FileNet_PERPC.WorkElement;
import filenet.pe.peorb.FileNet_PERPC.WorkObjectId;
import filenet.pe.peorb.FileNet_PERPC.WorkObjectIdOrVWExeption;
import filenet.pe.peorb.FileNet_PERPC.WorkfloSignature;
import filenet.vw.api.VWApplicationSpace;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWServerException;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWTableDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.api.VWWorkObjectNumber;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWCapsuleAES;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.util.Base64;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.VWConfigInfo;
import filenet.vw.server.VWConfigResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWField;
import filenet.vw.server.VWLogTableRecord;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.server.VWQueryResults;
import filenet.vw.server.VWQueueRecord;
import filenet.vw.server.VWRosterRecord;
import filenet.vw.server.VWSystemConfigInfo;
import filenet.vw.server.VWWorkObjectID;
import filenet.vw.server.VWWorkRecord;
import filenet.vw.server.WorkBasketRef;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ORBUtility {
    private static final String m_className = "ORBUtility";
    protected static final Logger exceptionLogger = Logger.getLogger("filenet.pe.rpc.exception");
    protected static final long INTERNAL_NUM = 234L;
    private static String STR_APPSPACENOTFOUND = new VWString("orb.notfoundappspace", "Application Space is not found").toString();
    private static String STR_ROLENOTFOUND = new VWString("orb.notfoundrole", "Role is not found").toString();
    private static final int QUEUE_TYPE_PROCESS = 1;
    private static final int QUEUE_TYPE_USER_CENTRIC = 2;
    private static final int QUEUE_TYPE_SYSTEM = 3;
    private static final int QUEUE_TYPE_CONNECTOR = 4;
    private static final int QUEUE_TYPE_ROSTER = 5;
    private static final int QUEUE_TYPE_LOG = 6;

    public static String _get_FILE_DATE() {
        return "$Date:   14 Oct 2008 22:56:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.113  $";
    }

    public static FValue ObjectToFValue(int vwType, Object o) {
        FValue val = new FValue();
        if (o == null) {
            SingleValue v = new SingleValue();
            v.n(true);
            val.v(v);
            return val;
        }
        boolean isArray = o.getClass().isArray();
        switch (vwType) {
            case 32: {
                if (!isArray) {
                    SingleValue v = new SingleValue();
                    v.a(o.toString());
                    val.v(FieldType.ATTACHMENT_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].s(itemArr[i].toString());
                }
                val.av(FieldType.ATTACHMENT_ARRAY_TYPE, vArr);
                break;
            }
            case 4: {
                if (!isArray) {
                    Boolean item = (Boolean)o;
                    SingleValue v = new SingleValue();
                    v.b(item);
                    val.v(FieldType.BOOLEAN_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].b((Boolean)itemArr[i]);
                }
                val.av(FieldType.BOOLEAN_ARRAY_TYPE, vArr);
                break;
            }
            case 8: {
                if (!isArray) {
                    Double item = (Double)o;
                    SingleValue v = new SingleValue();
                    v.f(item);
                    val.v(FieldType.FLOAT_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].f((Double)itemArr[i]);
                }
                val.av(FieldType.FLOAT_ARRAY_TYPE, vArr);
                break;
            }
            case 512: {
                if (!isArray) {
                    VWGuid item = (VWGuid)o;
                    SingleValue v = new SingleValue();
                    v.w1(item.toString());
                    val.v(FieldType.GUID_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].w1(((VWGuid)itemArr[i]).toString());
                }
                val.av(FieldType.GUID_ARRAY_TYPE, vArr);
                break;
            }
            case 1: {
                if (!isArray) {
                    Integer item = (Integer)o;
                    SingleValue v = new SingleValue();
                    v.t(item);
                    val.v(FieldType.INTEGER_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].t((Integer)itemArr[i]);
                }
                val.av(FieldType.INTEGER_ARRAY_TYPE, vArr);
                break;
            }
            case 64: {
                if (!isArray) {
                    SingleValue v = new SingleValue();
                    v.p(o.toString());
                    val.v(FieldType.PARTICIPANT_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                int realItems = 0;
                for (int i = 0; i < nItems; ++i) {
                    if (itemArr[i] == null) continue;
                    ++realItems;
                }
                if (realItems == 0) {
                    val.av(FieldType.PARTICIPANT_ARRAY_TYPE, new SingleValue[0]);
                    return val;
                }
                SingleValue[] vArr = new SingleValue[realItems];
                int j = 0;
                for (int i = 0; i < nItems; ++i) {
                    if (itemArr[i] == null) continue;
                    vArr[j] = new SingleValue();
                    vArr[j].s(itemArr[i].toString());
                    ++j;
                }
                val.av(FieldType.PARTICIPANT_ARRAY_TYPE, vArr);
                break;
            }
            case 2: {
                if (!isArray) {
                    SingleValue v = new SingleValue();
                    v.s(o.toString());
                    val.v(FieldType.STRING_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].s(itemArr[i].toString());
                }
                val.av(FieldType.STRING_ARRAY_TYPE, vArr);
                break;
            }
            case 16: 
            case 256: {
                if (!isArray) {
                    Date item = (Date)o;
                    SingleValue v = new SingleValue();
                    v.d(item.getTime() / 1000L);
                    val.v(FieldType.DATE_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].d(((Date)itemArr[i]).getTime() / 1000L);
                }
                val.av(FieldType.DATE_ARRAY_TYPE, vArr);
                break;
            }
            case 128: {
                if (!isArray) {
                    SingleValue v = new SingleValue();
                    v.x(o.toString());
                    val.v(FieldType.XML_TYPE, v);
                    break;
                }
                Object[] itemArr = (Object[])o;
                int nItems = itemArr.length;
                SingleValue[] vArr = new SingleValue[nItems];
                for (int i = 0; i < nItems; ++i) {
                    vArr[i] = new SingleValue();
                    if (itemArr[i] == null) {
                        vArr[i].n(true);
                        continue;
                    }
                    vArr[i].s(itemArr[i].toString());
                }
                val.av(FieldType.XML_ARRAY_TYPE, vArr);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static VWServerException mapServerException(filenet.pe.peorb.FileNet_PERPC.VWException e) {
        Throwable serverThrowable;
        block24: {
            serverThrowable = null;
            if (e.errorCause != null && e.errorCause.length > 0) {
                Exception ex222;
                ObjectInputStream p;
                ByteArrayInputStream stream;
                block22: {
                    stream = null;
                    p = null;
                    stream = new ByteArrayInputStream(e.errorCause);
                    p = new ObjectInputStream(stream);
                    serverThrowable = (Throwable)p.readObject();
                    Object var6_4 = null;
                    if (p == null) break block22;
                    try {
                        p.close();
                    }
                    catch (Exception ex222) {
                        // empty catch block
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception ex222) {}
                }
                break block24;
                {
                    catch (Exception ex3) {
                        Exception ex222;
                        Object var6_5 = null;
                        if (p != null) {
                            try {
                                p.close();
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception ex222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception ex222;
                    Object var6_6 = null;
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Exception ex222) {
                            // empty catch block
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception ex222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        switch (e.errorTuple) {
            case -714276828: {
                return new VWNoOnlineClassesException();
            }
        }
        VWServerException vws = new VWServerException("filenet.pe.peorb.serverException", e.errorTxt, Long.valueOf(e.errorTuple));
        if (serverThrowable != null) {
            vws.setCause(serverThrowable);
        }
        return vws;
    }

    public static Object FieldValuetoVWObject(FValue value, int vtype) throws VWException {
        Object[] val = null;
        if (value == null) {
            return val;
        }
        switch (value.discriminator().value()) {
            case 0: 
            case 11: {
                val = null;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                val = ORBUtility.processSingleValue(value.v(), vtype);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (value.av() == null) {
                    return null;
                }
                val = ORBUtility.processArrayValue(value.av(), vtype);
                break;
            }
            default: {
                return val;
            }
        }
        return val;
    }

    public static Object processSingleValue(SingleValue value, int vtype) throws VWException {
        Object val = null;
        if (value == null) {
            return val;
        }
        block0 : switch (value.discriminator().value()) {
            case 6: {
                val = value.a();
                break;
            }
            case 3: {
                val = value.b();
                break;
            }
            case 4: {
                val = new Double(value.f());
                break;
            }
            case 12: {
                VWGuid tmpVal;
                String strVal = value.w1().trim();
                if (strVal.length() <= 0 || (tmpVal = new VWGuid(strVal)) == null || tmpVal.isUndefined()) break;
                val = tmpVal;
                break;
            }
            case 1: {
                val = value.t();
                break;
            }
            case 7: {
                val = new VWParticipant(value.p());
                break;
            }
            case 8: {
                ParticipantStruct ps = value.ps();
                val = VWClassFactory.createVWParticipant(ps.realm, ps.shortName, ps.dn, ps.displayName, null, -1L, ps.objectClass ? 2 : 1, 234L);
                break;
            }
            case 2: {
                switch (vtype) {
                    case 64: {
                        val = new VWParticipant(value.s());
                        break block0;
                    }
                    case 32: {
                        val = value.s();
                        break block0;
                    }
                    case 128: {
                        val = VWClassFactory.createVWXMLData(value.s(), 234L);
                        break block0;
                    }
                }
                val = value.s();
                break;
            }
            case 5: {
                val = new Date(value.d() * 1000L);
                break;
            }
            case 9: {
                val = VWClassFactory.createVWXMLData(value.x(), 234L);
                break;
            }
            case 0: 
            case 11: {
                val = null;
                break;
            }
            default: {
                return val;
            }
        }
        return val;
    }

    public static Object[] processArrayValue(SingleValue[] svarr, int vtype) throws VWException {
        Object[] val = null;
        int nItems = svarr.length;
        block0 : switch (vtype) {
            case 32: {
                val = new String[nItems];
                break;
            }
            case 4: {
                val = new Boolean[nItems];
                break;
            }
            case 8: {
                val = new Double[nItems];
                break;
            }
            case 512: {
                val = new VWGuid[nItems];
                break;
            }
            case 1: {
                val = new Integer[nItems];
                break;
            }
            case 64: {
                val = new VWParticipant[nItems];
                break;
            }
            case 2: {
                val = new String[nItems];
                break;
            }
            case 16: 
            case 256: {
                val = new Date[nItems];
                break;
            }
            case 128: {
                val = new VWXMLData[nItems];
                break;
            }
            default: {
                vtype = 0;
                if (nItems > 0) {
                    boolean bMixedTypes = false;
                    int vtype2 = svarr[0].discriminator().value();
                    for (int i = 0; i < nItems; ++i) {
                        if (svarr[i].discriminator().value() == vtype2) continue;
                        bMixedTypes = true;
                    }
                    if (!bMixedTypes) {
                        switch (vtype2) {
                            case 6: {
                                val = new String[nItems];
                                vtype = 32;
                                break block0;
                            }
                            case 3: {
                                val = new Boolean[nItems];
                                vtype = 4;
                                break block0;
                            }
                            case 4: {
                                val = new Double[nItems];
                                vtype = 8;
                                break block0;
                            }
                            case 12: {
                                val = new VWGuid[nItems];
                                vtype = 512;
                                break block0;
                            }
                            case 1: {
                                val = new Integer[nItems];
                                vtype = 1;
                                break block0;
                            }
                            case 7: 
                            case 8: {
                                val = new VWParticipant[nItems];
                                vtype = 64;
                                break block0;
                            }
                            case 2: {
                                val = new String[nItems];
                                vtype = 2;
                                break block0;
                            }
                            case 5: {
                                val = new Date[nItems];
                                vtype = 16;
                                break block0;
                            }
                            case 9: {
                                val = new VWXMLData[nItems];
                                vtype = 128;
                                break block0;
                            }
                        }
                        vtype = 0;
                        val = new Object[nItems];
                        break;
                    }
                    val = new Object[nItems];
                    break;
                }
                val = new Object[nItems];
            }
        }
        if (nItems == 0) {
            return val;
        }
        for (int i = 0; i < nItems; ++i) {
            val[i] = ORBUtility.processSingleValue(svarr[i], vtype);
        }
        return val;
    }

    public static VWField FieldtoVWField(Field f) throws VWException {
        try {
            VWField vf = null;
            Object val = ORBUtility.FieldValuetoVWObject(f.value, f.fieldType);
            vf = new VWField(f.name, f.mode, val, f.isSystemField, f.fieldType, f.isArray, f.displayString);
            return vf;
        }
        catch (Exception e) {
            String m_method = "FieldToVWField:" + (f == null ? "NULL" : f.name) + "," + (f == null ? "0" : Integer.toString(f.fieldType));
            exceptionLogger.throwing(m_className, m_method, e);
            throw new VWException(e);
        }
    }

    public static VWFieldDefinition FieldtoVWFieldDefinition(VWWorkflowSignature sig, Field f) throws VWException {
        VWFieldDefinition vf = null;
        Object val = ORBUtility.FieldValuetoVWObject(f.value, 2);
        vf = VWClassFactory.createVWFieldDefinition(sig, f.name, val.toString(), f.fieldType, f.isArray, f.displayString, f.mode, f.isSystemField, 234L);
        return vf;
    }

    public static SingleValue ObjectToSingleValue(Object o) {
        SingleValue v = new SingleValue();
        if (o == null) {
            v.n(true);
            return v;
        }
        int vwType = VWFieldType.getVWFieldType(o);
        switch (vwType) {
            case 32: {
                VWAttachment item = (VWAttachment)o;
                v.a(item.toString());
                break;
            }
            case 4: {
                Boolean item = (Boolean)o;
                v.b(item);
                break;
            }
            case 8: {
                Double item = (Double)o;
                v.f(item);
                break;
            }
            case 512: {
                VWGuid item = (VWGuid)o;
                v.w1(item.toString());
                break;
            }
            case 1: {
                Integer item = (Integer)o;
                v.t(item);
                break;
            }
            case 64: {
                VWParticipant item = (VWParticipant)o;
                v.p(item.toString());
                break;
            }
            case 2: {
                String item = (String)o;
                v.s(item);
                break;
            }
            case 16: 
            case 256: {
                Date item = (Date)o;
                v.d(item.getTime() / 1000L);
                break;
            }
            case 128: {
                VWXMLData item = (VWXMLData)o;
                v.x(item.toString());
                break;
            }
            default: {
                String item = o.toString();
                if (o instanceof VWWorkObjectNumber) {
                    v.w(item);
                    break;
                }
                v.s(item);
            }
        }
        return v;
    }

    public static FValue ObjectArrayToFValue(Object[] o) {
        FValue f = new FValue();
        if (o != null) {
            int nItems = o.length;
            SingleValue[] vArr = new SingleValue[nItems];
            for (int i = 0; i < nItems; ++i) {
                vArr[i] = ORBUtility.ObjectToSingleValue(o[i]);
            }
            f.av(FieldType.MIXED_ARRAY_TYPE, vArr);
        } else {
            SingleValue v = new SingleValue();
            v.n(true);
            f.v(FieldType.NOTHING_TYPE, v);
        }
        return f;
    }

    public static VWField[] FieldArraytoVWFieldArray(Field[] f) throws VWException {
        int len;
        VWField[] vwf = null;
        int n = len = f == null ? 0 : f.length;
        if (f != null) {
            vwf = new VWField[len];
            for (int j = 0; j < len; ++j) {
                VWField field;
                vwf[j] = field = ORBUtility.FieldtoVWField(f[j]);
            }
        }
        return vwf;
    }

    public static Field VWFieldtoField(VWField f) {
        Field field = null;
        if (f != null) {
            FValue val = ORBUtility.ObjectToFValue(f.getType(), f.getValue());
            Boolean[] Ba = f.hasBeenAlteredArray();
            int nItems = Ba == null ? 0 : Ba.length;
            boolean[] ba = new boolean[nItems];
            for (int j = 0; j < nItems; ++j) {
                ba[j] = Ba[j];
            }
            field = new Field(f.getName(), val, f.getType(), f.isSystemField(), f.isArray(), f.getMode(), f.hasBeenAltered(), ba, f.getDescription(), "");
        } else {
            FValue val = ORBUtility.ObjectToFValue(2, "");
            field = new Field("", val, 2, true, false, 3, false, new boolean[0], "", "");
        }
        return field;
    }

    public static Field[] VWFieldArraytoFieldArray(VWField[] f) {
        Field[] orbf = null;
        int nFields = f == null ? 0 : f.length;
        orbf = new Field[nFields];
        for (int j = 0; j < nFields; ++j) {
            Field field;
            orbf[j] = field = ORBUtility.VWFieldtoField(f[j]);
        }
        return orbf;
    }

    protected static VWExposedFieldDefinition makeVWExposedFieldDefinition(ExposedFieldDefinition exField) throws VWException {
        VWExposedFieldDefinition res = VWClassFactory.createVWExposedFieldDefinition(exField.fieldName, exField.type, exField.length, exField.isSystemField, exField.sourceName, exField.sourceType, 234L);
        VWClassFactory.VWExposedFieldDefinition_setMandatorySystemField(res, exField.isMandatorySystemField, 234L);
        return res;
    }

    public static VWExposedFieldDefinition[] getExposedFieldArray(ExposedFieldDefinition[] exFields) throws VWException {
        if (exFields == null) {
            return null;
        }
        int nItems = exFields.length;
        VWExposedFieldDefinition[] res = new VWExposedFieldDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWExposedFieldDefinition(exFields[i]);
        }
        return res;
    }

    public static VWIndexDefinition[] getIndexDefinitionArray(IndexDefinition[] idef, VWTableDefinition tdef) throws VWException {
        if (idef == null) {
            return null;
        }
        int nIndexes = idef.length;
        VWIndexDefinition[] res = new VWIndexDefinition[nIndexes];
        for (int i = 0; i < nIndexes; ++i) {
            res[i] = VWClassFactory.createVWIndexDefinition(idef[i].indexName, idef[i].fieldNames, idef[i].isSystemIndex, tdef, true, 234L);
        }
        return res;
    }

    private static VWConfigInfo[] getConfigInfoArray(ConfigInfo[] c) {
        if (c == null) {
            return null;
        }
        int nItems = c.length;
        VWConfigInfo[] res = new VWConfigInfo[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = new VWConfigInfo(c[i].name, c[i].viewId, c[i].classId, 0, null, c[i].isQueue, c[i].qType == 4 ? 1 : c[i].qType, c[i].qType == 4);
        }
        return res;
    }

    public static VWConfigResult mapORBConfigResult(ConfigResult c) {
        if (c == null) {
            return null;
        }
        VWConfigResult res = null;
        VWConfigInfo[] qC = ORBUtility.getConfigInfoArray(c.queueConfigs);
        VWConfigInfo[] rC = ORBUtility.getConfigInfoArray(c.rosterConfigs);
        VWConfigInfo[] wcC = ORBUtility.getConfigInfoArray(c.workClassConfigs);
        res = new VWConfigResult(rC, qC, wcC, c.NCHServerName, c.dbType, c.webAppDefault, c.systemWideFlag);
        return res;
    }

    public static VWConfigResult updateConfigResultFromConfigHdrResult(VWConfigResult cur, ConfigHdrResult c) {
        if (c == null) {
            return cur;
        }
        if (c.NCHServerName != null) {
            cur.setNCHServerName(c.NCHServerName);
        }
        cur.setSystemWideFlag(c.systemWideFlag);
        cur.setDBType(c.dbType);
        cur.setIsolatedRegionDefaultWebApp(c.webAppDefault);
        Vector<VWConfigInfo> q = new Vector<VWConfigInfo>();
        Vector<VWConfigInfo> r = new Vector<VWConfigInfo>();
        int nConfigs = c.dbConfigs == null ? 0 : c.dbConfigs.length;
        block4: for (int i = 0; i < nConfigs; ++i) {
            ConfigHdrStruct aCStruct = c.dbConfigs[i];
            boolean isQueue = aCStruct.qType != 5 && aCStruct.qType != 6;
            VWConfigInfo aConfig = new VWConfigInfo(aCStruct.name, aCStruct.viewId, aCStruct.classId, 0, null, isQueue, aCStruct.qType == 4 ? 1 : aCStruct.qType, aCStruct.qType == 4);
            switch (aCStruct.qType) {
                case 5: {
                    r.add(aConfig);
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    q.add(aConfig);
                    continue block4;
                }
            }
        }
        VWConfigInfo[] qC = q.toArray(new VWConfigInfo[0]);
        VWConfigInfo[] rC = r.toArray(new VWConfigInfo[0]);
        cur.setQueueConfigs(qC);
        cur.setRosterConfig(rC);
        return cur;
    }

    public static VWWorkObjectID getWorkObjectId(WorkObjectId w) {
        if (w == null) {
            return null;
        }
        VWWorkObjectID wobId = new VWWorkObjectID(w.uniqueID, w.wobNumber, 0, w.queueId);
        return wobId;
    }

    public static WorkObjectId getWorkObjectIdFromVWWorkObjectId(VWWorkObjectID w) {
        if (w == null) {
            return null;
        }
        WorkObjectId res = new WorkObjectId(w.getUniqueID(), w.getWorkObjectNumber(), w.getQueueId());
        return res;
    }

    public static WorkObjectId[] getWorkObjectIdsFromVWWorkObjectIds(VWWorkObjectID[] w) {
        if (w == null) {
            return null;
        }
        int nItems = w.length;
        WorkObjectId[] res = new WorkObjectId[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.getWorkObjectIdFromVWWorkObjectId(w[i]);
        }
        return res;
    }

    public static WorkElement WorkElementFromFieldandIds(VWField[] f, VWWorkObjectID id) {
        WorkElement we = null;
        Field[] fields = ORBUtility.VWFieldArraytoFieldArray(f);
        WorkObjectId wobId = ORBUtility.getWorkObjectIdFromVWWorkObjectId(id);
        we = new WorkElement(fields, wobId);
        return we;
    }

    public static WorkElement[] WorkElementsFromFieldandIds(VWField[][] f, VWWorkObjectID[] ids) {
        int fln = 0;
        if (ids != null) {
            fln = ids.length;
        }
        WorkElement[] res = new WorkElement[fln];
        for (int i = 0; i < fln; ++i) {
            res[i] = f == null ? ORBUtility.WorkElementFromFieldandIds(null, ids[i]) : ORBUtility.WorkElementFromFieldandIds(f[i], ids[i]);
        }
        return res;
    }

    public static Object[] convertWorkObjectIdOrVWExeption(WorkObjectIdOrVWExeption[] objres) {
        int ln;
        Object[] res = null;
        int n = ln = objres == null ? 0 : objres.length;
        if (ln == 0) {
            return null;
        }
        res = new Object[ln];
        block5: for (int i = 0; i < ln; ++i) {
            switch (objres[i].discriminator().value()) {
                case 2: {
                    res[i] = null;
                    continue block5;
                }
                case 1: {
                    filenet.pe.peorb.FileNet_PERPC.VWException vwEx = new filenet.pe.peorb.FileNet_PERPC.VWException(objres[i].err().errorTuple, objres[i].err().errorTxt, objres[i].err().errorCause);
                    res[i] = ORBUtility.mapServerException(vwEx);
                    continue block5;
                }
                case 0: {
                    res[i] = ORBUtility.getWorkObjectId(objres[i].wobid());
                    continue block5;
                }
                default: {
                    res[i] = new VWException("orb.session.ExceptionConvertTypeErr", objres.toString());
                }
            }
        }
        return res;
    }

    public static WorkElement VWWorkRecordToWorkElement(VWWorkRecord wr) {
        WorkElement we = null;
        if (wr == null) {
            WorkObjectId wobId = new WorkObjectId(0.0, new byte[0], 0);
            we = new WorkElement(new Field[0], wobId);
        } else {
            Field[] fields = ORBUtility.VWFieldArraytoFieldArray(wr.getUserFields());
            WorkObjectId wobId = new WorkObjectId(0.0, wr.getWorkObjectNumber(), 0);
            we = new WorkElement(fields, wobId);
        }
        return we;
    }

    public static WorkElement Base64WOBToWorkElement(String sBase64WOB) {
        WorkObjectId wobId = new WorkObjectId(0.0, Base64.decode(sBase64WOB), 0);
        return new WorkElement(new Field[0], wobId);
    }

    public static VWQueryResults getVWQueryResults(QueryResult q, int queryType) throws VWException {
        if (q == null) {
            return null;
        }
        VWQueryResults res = new VWQueryResults(null, null, null, q.rpUniqueId, q.queryFinished);
        int nWobs = q.queryObject == null ? 0 : q.queryObject.length;
        VWField[][] wobFields = new VWField[nWobs][];
        VWWorkObjectID[] wobids = new VWWorkObjectID[nWobs];
        for (int i = 0; i < nWobs; ++i) {
            wobFields[i] = ORBUtility.FieldArraytoVWFieldArray(q.queryObject[i].fields);
            wobids[i] = ORBUtility.getWorkObjectId(q.queryObject[i].wobId);
        }
        VWWorkRecord lastRecord = null;
        VWWorkObjectID lastRecWobID = null;
        VWField[] lastRecFields = null;
        boolean isLastRec = false;
        isLastRec = q.lastRec.wobId.queueId != -999;
        if (isLastRec) {
            lastRecWobID = ORBUtility.getWorkObjectId(q.lastRec.wobId);
            lastRecFields = ORBUtility.FieldArraytoVWFieldArray(q.lastRec.fields);
        }
        if (nWobs > 0) {
            switch (queryType) {
                case 2: {
                    lastRecord = new VWQueueRecord(wobids[nWobs - 1].getWorkObjectNumber(), wobFields[nWobs - 1]);
                    if (!isLastRec) break;
                    lastRecord = new VWQueueRecord(lastRecWobID.getWorkObjectNumber(), lastRecFields);
                    break;
                }
                case 1: {
                    lastRecord = new VWRosterRecord(wobids[nWobs - 1].getWorkObjectNumber(), wobFields[nWobs - 1]);
                    if (!isLastRec) break;
                    lastRecord = new VWRosterRecord(lastRecWobID.getWorkObjectNumber(), lastRecFields);
                    break;
                }
                case 3: {
                    lastRecord = new VWLogTableRecord(wobids[nWobs - 1].getWorkObjectNumber(), wobFields[nWobs - 1]);
                    if (!isLastRec) break;
                    lastRecord = new VWLogTableRecord(lastRecWobID.getWorkObjectNumber(), lastRecFields);
                    break;
                }
            }
            res = new VWQueryResults(wobFields, wobids, lastRecord, q.rpUniqueId, q.queryFinished);
        }
        return res;
    }

    public static VWStepProcessorInfo StepProcessortoVWStepProcessor(StepProcessorInfo stProc) throws VWException {
        VWStepProcessorInfo vwstProc = null;
        if (stProc == null || stProc.Locations == null) {
            return vwstProc;
        }
        int locLength = stProc.Locations.length;
        Hashtable<Integer, String> locations = new Hashtable<Integer, String>(locLength);
        for (int i = 0; i < locLength; ++i) {
            locations.put(new Integer(stProc.Locations[i].l), stProc.Locations[i].s);
        }
        vwstProc = VWClassFactory.createVWStepProcessorInfo(stProc.id, stProc.ProcessorType, stProc.Name, stProc.AppType, locations, stProc.width, stProc.height, stProc.appName, 234L);
        return vwstProc;
    }

    public static VWEnvironmentData EnvironmentDataToVWEnvironmentData(EnvironmentData env) throws VWException {
        VWEnvironmentData res = null;
        if (env == null) {
            return res;
        }
        VWParticipant vwPart = VWClassFactory.createVWParticipant(env.shortName, env.PEId, null, 234L);
        int fldLength = env.fields.length;
        Hashtable<String, Object> fieldsTable = new Hashtable<String, Object>(fldLength);
        Object val = null;
        for (int i = 0; i < fldLength; ++i) {
            val = ORBUtility.FieldValuetoVWObject(env.fields[i].v, 0);
            fieldsTable.put(env.fields[i].s, val);
        }
        res = new VWEnvironmentData(env.shortName, vwPart, fieldsTable, env.timeStamp);
        return res;
    }

    public static EnvironmentData VWEnvironmentDataToEnvironmentData(VWEnvironmentData env) throws VWException {
        EnvironmentData res = new EnvironmentData();
        if (env == null) {
            return res;
        }
        Hashtable fieldsTable = env.getFieldsTable();
        if (fieldsTable != null) {
            Enumeration keys = fieldsTable.keys();
            int size = fieldsTable.size();
            res.fields = new StringAndFValue[size];
            int vwType = 0;
            int i = 0;
            while (keys.hasMoreElements()) {
                res.fields[i] = new StringAndFValue();
                res.fields[i].s = (String)keys.nextElement();
                Object val = fieldsTable.get(res.fields[i].s);
                vwType = VWFieldType.getVWFieldType(val);
                res.fields[i].v = ORBUtility.ObjectToFValue(vwType, val);
                ++i;
            }
        }
        VWParticipant px = env.getUserPx();
        res.shortName = px.getParticipantName();
        res.PEId = (int)px.getUserId();
        res.timeStamp = (int)env.getTimeStamp();
        return res;
    }

    public static VWParticipant ParticipantToVWParticipant(ParticipantStruct p) throws VWException {
        VWParticipant res = null;
        if (p == null) {
            return res;
        }
        res = VWClassFactory.createVWParticipant(p.realm, p.shortName, p.dn, p.displayName, null, p.usrId != 0 ? (long)p.usrId : -1L, p.objectClass ? 2 : 1, 234L);
        return res;
    }

    public static VWParticipant[] ParticipantArrayToVWParticipantArray(ParticipantStruct[] a) throws VWException {
        VWParticipant[] res = null;
        if (a != null) {
            int i;
            int numEntries = a.length;
            int realCnt = 0;
            for (i = 0; i < numEntries; ++i) {
                if (a[i].shortName == null || a[i].shortName.length() <= 0) continue;
                ++realCnt;
            }
            if (realCnt == 0) {
                return res;
            }
            res = new VWParticipant[realCnt];
            for (i = 0; i < realCnt; ++i) {
                res[i] = ORBUtility.ParticipantToVWParticipant(a[i]);
            }
        }
        return res;
    }

    public static VWWorkflowSignature[] WorkflowSignatureArraytoVWWorkflowSignatureArray(WorkfloSignature[] wfsigs) throws VWException {
        int len;
        VWWorkflowSignature[] vws = null;
        int n = len = wfsigs == null ? 0 : wfsigs.length;
        if (wfsigs != null) {
            vws = new VWWorkflowSignature[len];
            for (int j = 0; j < len; ++j) {
                VWWorkflowSignature sig;
                vws[j] = sig = ORBUtility.WorkflowSignaturetoVWWorkflowSignature(wfsigs[j]);
            }
        }
        return vws;
    }

    public static VWWorkflowSignature WorkflowSignaturetoVWWorkflowSignature(WorkfloSignature wfSig) throws VWException {
        VWWorkflowSignature res = null;
        if (wfSig == null) {
            return res;
        }
        VWParticipant vwPart = ORBUtility.ParticipantToVWParticipant(wfSig.participantObj);
        int ISLength = wfSig.ISheets.length;
        String[] theInstructionSheetNames = new String[ISLength];
        int[] theInstructionSheetIds = new int[ISLength];
        for (int i = 0; i < ISLength; ++i) {
            theInstructionSheetNames[i] = wfSig.ISheets[i].s;
            theInstructionSheetIds[i] = new Integer(wfSig.ISheets[i].l);
        }
        res = VWClassFactory.createVWWorkflowSignature(vwPart, new Date((long)wfSig.TransferDateTime * 1000L), wfSig.WobFTagExpr, wfSig.WobFTagType, null, theInstructionSheetNames, theInstructionSheetIds, wfSig.RosterName, wfSig.EventLogName, wfSig.WorkClassDescription, wfSig.MilestoneNames, wfSig.RulesetNames, wfSig.PartnerlinkNames, wfSig.SchemaNames, wfSig.WorkClassName, wfSig.WSId, wfSig.HasMyPortType, wfSig.BaseWorkClassName, wfSig.VersionAgnostic, 234L);
        int fldLength = wfSig.FieldDefs.length;
        VWFieldDefinition[] theFieldDefinitions = new VWFieldDefinition[fldLength];
        for (int i = 0; i < fldLength; ++i) {
            theFieldDefinitions[i] = ORBUtility.FieldtoVWFieldDefinition(res, wfSig.FieldDefs[i]);
        }
        res.setFields(theFieldDefinitions);
        return res;
    }

    public static VWDBExecuteConnection DBConnectionToVWDBExecuteConnection(DBConnection dbEx) throws VWException {
        VWDBExecuteConnection res = null;
        if (dbEx == null) {
            return res;
        }
        res = new VWDBExecuteConnection(dbEx.name, dbEx.dbType, dbEx.connectionURL, dbEx.dbName, dbEx.dbHost, dbEx.dbPort, dbEx.dbUserName, dbEx.dbPassWd, dbEx.changed);
        return res;
    }

    public static DBConnection VWDBExecuteConnectionToDBConnection(VWDBExecuteConnection dbEx) throws VWException {
        DBConnection res = new DBConnection();
        if (dbEx == null) {
            return res;
        }
        res.name = dbEx.getName() != null ? dbEx.getName() : "";
        res.connectionURL = dbEx.getURL() != null ? dbEx.getURL() : "";
        res.dbHost = dbEx.getDbHostName() != null ? dbEx.getDbHostName() : "";
        res.dbName = dbEx.getDbName() != null ? dbEx.getDbName() : "";
        res.dbUserName = dbEx.getDbUserId() != null ? dbEx.getDbUserId() : "";
        res.changed = dbEx.getHasChanged();
        if (res.changed) {
            VWCapsuleAES aes = new VWCapsuleAES();
            try {
                res.dbPassWd = aes.encrypt("", dbEx.getPWD());
            }
            catch (Exception e) {
                throw new VWException(e);
            }
        } else {
            res.dbPassWd = dbEx.getPWD() != null ? dbEx.getPWD() : "";
        }
        res.dbPort = dbEx.getDbPort();
        res.dbType = dbEx.getDbType();
        return res;
    }

    protected static VWRosterDefinition makeVWRosterDefinition(RosterDefinition res) throws VWException {
        VWRosterDefinition rdef = null;
        if (res != null) {
            if (res.name == null || res.name.length() == 0) {
                return null;
            }
            rdef = VWClassFactory.createVWRosterDefinition(res.name, 234L);
            VWExposedFieldDefinition[] exFields = ORBUtility.getExposedFieldArray(res.exposedFields);
            VWIndexDefinition[] indexes = ORBUtility.getIndexDefinitionArray(res.indexes, rdef);
            rdef.createFieldDefinitions(exFields);
            rdef.createIndexDefinitions(indexes);
            rdef.setDescription(res.description);
            rdef.setServerId(res.serverid);
            rdef.setCreateSecurityPx(ORBUtility.ParticipantArrayToVWParticipantArray(res.createSecurityPx));
            rdef.setReadSecurityPx(ORBUtility.ParticipantArrayToVWParticipantArray(res.readSecurityPx));
            rdef.setWriteSecurityPx(ORBUtility.ParticipantArrayToVWParticipantArray(res.writeSecurityPx));
        }
        VWClassFactory.VWRosterDefinition_setHasChanged(rdef, false, 234L);
        return rdef;
    }

    private static VWRosterDefinition[] makeVWRosterDefinitionArray(RosterDefinition[] oArr) throws VWException {
        int nItems;
        int n = nItems = oArr == null ? 0 : oArr.length;
        if (nItems == 0) {
            return null;
        }
        VWRosterDefinition[] res = new VWRosterDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWRosterDefinition(oArr[i]);
        }
        return res;
    }

    protected static VWLogDefinition makeVWLogDefinition(LogDefinition o) throws VWException {
        if (o.name == null || o.name.length() == 0) {
            return null;
        }
        VWLogDefinition ldef = VWClassFactory.createVWLogDefinition(o.name, 234L);
        VWExposedFieldDefinition[] exFields = ORBUtility.getExposedFieldArray(o.exposedFields);
        VWIndexDefinition[] indexes = ORBUtility.getIndexDefinitionArray(o.indexes, ldef);
        VWClassFactory.VWLogDefinition_createFieldDefinitions(ldef, exFields, 234L);
        VWClassFactory.VWLogDefinition_createIndexDefinitions(ldef, indexes, 234L);
        ldef.setDescription(o.description);
        ldef.setServerId(0);
        VWClassFactory.VWLogDefinition_setHasChanged(ldef, false, 234L);
        return ldef;
    }

    private static VWLogDefinition[] makeVWLogDefinitionArray(LogDefinition[] oArr) throws VWException {
        int nItems;
        int n = nItems = oArr == null ? 0 : oArr.length;
        if (nItems == 0) {
            return null;
        }
        VWLogDefinition[] res = new VWLogDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWLogDefinition(oArr[i]);
        }
        return res;
    }

    private static VWStepProcessorInfoDefinition makeVWStepProcInfo(StepProcessorInfo o) throws VWException {
        int locLength = o.Locations.length;
        Hashtable<Integer, String> locations = new Hashtable<Integer, String>(locLength);
        for (int j = 0; j < locLength; ++j) {
            locations.put(new Integer(o.Locations[j].l), o.Locations[j].s);
        }
        VWStepProcessorInfoDefinition newSP = new VWStepProcessorInfoDefinition(o.id, o.ProcessorType, o.Name, o.AppType, locations, o.width, o.height, o.appName);
        VWClassFactory.VWStepProcessorInfoDef_setAlreadyTransferred(newSP, 234L);
        return newSP;
    }

    private static VWStepProcessorInfoDefinition[] makeVWStepProcInfoArray(StepProcessorInfo[] oArr) throws VWException {
        int nItems;
        int n = nItems = oArr == null ? 0 : oArr.length;
        if (nItems == 0) {
            return null;
        }
        VWStepProcessorInfoDefinition[] res = new VWStepProcessorInfoDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWStepProcInfo(oArr[i]);
        }
        return res;
    }

    private static Hashtable makeVWAttributes(StringAndFValue[] oAttr) throws VWException {
        int nItems;
        int n = nItems = oAttr == null ? 0 : oAttr.length;
        if (nItems == 0) {
            return null;
        }
        Hashtable<String, Object> res = new Hashtable<String, Object>(nItems);
        for (int i = 0; i < nItems; ++i) {
            Object value = ORBUtility.FieldValuetoVWObject(oAttr[i].v, 0);
            if (value == null) continue;
            res.put(oAttr[i].s, value);
        }
        return res;
    }

    private static StringAndFValue[] VWAttributetoOrbStringFValue(VWAttributeInfo oAttr) throws VWException {
        StringAndFValue[] res = null;
        int vwType = 0;
        Object val = null;
        if (oAttr == null) {
            return new StringAndFValue[0];
        }
        String[] names = oAttr.getAttributeNames();
        int nItems = names == null ? 0 : names.length;
        res = new StringAndFValue[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = new StringAndFValue();
            res[i].s = names[i];
            val = oAttr.getFieldValue(res[i].s);
            vwType = VWFieldType.getVWFieldType(val);
            res[i].v = ORBUtility.ObjectToFValue(vwType, val);
        }
        return res;
    }

    protected static VWQueueDefinition makeVWQueueDefinition(QueueDefinition res) throws VWException {
        if (res.name == null || res.name.length() == 0) {
            return null;
        }
        VWQueueDefinition qdef = VWClassFactory.createVWQueueDefinition(res.name, res.queueType, 234L);
        VWExposedFieldDefinition[] exFields = ORBUtility.getExposedFieldArray(res.exposedFields);
        VWIndexDefinition[] indexes = ORBUtility.getIndexDefinitionArray(res.indexes, qdef);
        VWClassFactory.VWQueueDefinition_createFieldDefinitions(qdef, exFields, 234L);
        VWClassFactory.VWQueueDefinition_createIndexDefinitions(qdef, indexes, 234L);
        qdef.setDescription(res.description);
        qdef.setIsConnectorQueue(res.isConnectorQueue);
        qdef.setServerId(res.serverid != -1 ? res.serverid : -99);
        qdef.setReadSecurityPx(ORBUtility.ParticipantArrayToVWParticipantArray(res.readSecurityPx));
        qdef.setWriteSecurityPx(ORBUtility.ParticipantArrayToVWParticipantArray(res.writeSecurityPx));
        int numAttrs = res.attributes.length;
        if (numAttrs > 0) {
            qdef.setAttributeInfo(VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(res.attributes), 234L));
        }
        int numOps = res.operations.length;
        for (int i = 0; i < numOps; ++i) {
            VWOperationDefinition newOp = qdef.createOperation(res.operations[i].name);
            newOp.setDescription(res.operations[i].description);
            newOp.setAttributeInfo(VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(res.operations[i].attributes), 234L));
            int numParams = res.operations[i].parameters.length;
            for (int j = 0; j < numParams; ++j) {
                try {
                    VWParameterDefinition newP = newOp.createParameter(res.operations[i].parameters[j].name, res.operations[i].parameters[j].mode, res.operations[i].parameters[j].fieldType, res.operations[i].parameters[j].isArray);
                    newP.setDescription(res.operations[i].parameters[j].displayString);
                    continue;
                }
                catch (Exception x) {
                    throw new VWException(x);
                }
            }
        }
        ORBUtility.makeVWWorkBasketDefinitions(res.workBaskets, qdef);
        VWClassFactory.VWQueueDefinition_setHasChanged(qdef, false, 234L);
        return qdef;
    }

    private static VWWorkBasketFilterDefinition[] makeVWWorkBasketFilterDefinitionArray(WorkBasketFilterDefinition[] oArr, boolean forRuntime) throws VWException {
        int nItems = oArr == null ? 0 : oArr.length;
        VWWorkBasketFilterDefinition[] res = new VWWorkBasketFilterDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWWorkBasketFilterDefinition(oArr[i], forRuntime);
        }
        return res;
    }

    private static VWWorkBasketFilterDefinition makeVWWorkBasketFilterDefinition(WorkBasketFilterDefinition orbWBFilterDef, boolean forRuntime) throws VWException {
        if (orbWBFilterDef == null) {
            return null;
        }
        String expFieldName = orbWBFilterDef.searchField.fieldName;
        VWWorkBasketFilterDefinition res = VWClassFactory.createVWWorkBasketFilterDefinition(orbWBFilterDef.name, orbWBFilterDef.description, orbWBFilterDef.prompt, orbWBFilterDef._operator, VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(orbWBFilterDef.attributes), 234L), expFieldName, 234L);
        if (forRuntime) {
            VWClassFactory.VWWorkBasketFilterDefinition_setType(res, orbWBFilterDef.searchField.type, 234L);
        }
        return res;
    }

    private static VWWorkBasketColumnDefinition makeVWWorkBasketColumnDefinition(WorkBasketColumnDefinition orbColDef, boolean forRuntime) throws VWException {
        if (orbColDef == null) {
            return null;
        }
        String expFieldName = orbColDef.field.fieldName;
        VWWorkBasketColumnDefinition res = VWClassFactory.createVWWorkBasketColumnDefinition(orbColDef.prompt, orbColDef.sortable, orbColDef.indexName, VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(orbColDef.attributes), 234L), expFieldName, 234L);
        if (forRuntime) {
            VWClassFactory.VWWorkBasketColumnDefinition_setType(res, orbColDef.field.type, 234L);
        }
        return res;
    }

    private static VWWorkBasketColumnDefinition[] makeVWWorkBasketColumnDefinitionArray(WorkBasketColumnDefinition[] oArr, boolean forRuntime) throws VWException {
        int nItems;
        int n = nItems = oArr == null ? 0 : oArr.length;
        if (nItems == 0) {
            return null;
        }
        VWWorkBasketColumnDefinition[] res = new VWWorkBasketColumnDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWWorkBasketColumnDefinition(oArr[i], forRuntime);
        }
        return res;
    }

    private static WorkBasketColumnDefinition makeORBWorkBasketColumnDefinition(VWWorkBasketColumnDefinition vwColDef) throws VWException {
        if (vwColDef != null) {
            return new WorkBasketColumnDefinition(ORBUtility.nonNullString(vwColDef.getPrompt()), ORBUtility.makeOneORBExposedFieldDef(vwColDef.getColumn()), vwColDef.isSortable(), ORBUtility.nonNullString(vwColDef.getIndexName()), ORBUtility.VWAttributetoOrbStringFValue(vwColDef.getAttributeInfo()));
        }
        return new WorkBasketColumnDefinition("", new ExposedFieldDefinition(), false, "", new StringAndFValue[0]);
    }

    private static WorkBasketColumnDefinition[] makeORBWorkBasketColumnDefinitionArray(VWWorkBasketColumnDefinition[] oArr) throws VWException {
        int nItems = oArr == null ? 0 : oArr.length;
        WorkBasketColumnDefinition[] res = new WorkBasketColumnDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeORBWorkBasketColumnDefinition(oArr[i]);
        }
        return res;
    }

    private static VWQueueDefinition[] makeVWQueueDefinitionArray(QueueDefinition[] oArr) throws VWException {
        int nItems;
        int n = nItems = oArr == null ? 0 : oArr.length;
        if (nItems == 0) {
            return null;
        }
        VWQueueDefinition[] res = new VWQueueDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWQueueDefinition(oArr[i]);
        }
        return res;
    }

    public static VWSystemConfigInfo SystemConfigInfoToVWSystemConfigInfo(SystemConfigInfo o) throws VWException {
        VWSystemConfigInfo res = new VWSystemConfigInfo();
        res.setMaxDBOperations(o.MaxDBOperations);
        res.setMaxInstructions(o.MaxInstructions);
        res.setLoggingState(o.LoggingState);
        res.setStatisticsCollection(o.statsEnabled);
        res.setTrackAttachmentReferences(o.TrackAttachmentReferences);
        res.setDefaultLogDefinition(ORBUtility.makeVWLogDefinition(o.DefaultLog));
        res.setStepProcessorInfoDefinitions(ORBUtility.makeVWStepProcInfoArray(o.StepProcessorInfoDefs));
        res.setLogDefinitions(ORBUtility.makeVWLogDefinitionArray(o.logDefinitions));
        res.setQueueDefinitions(ORBUtility.makeVWQueueDefinitionArray(o.queueDefinitions));
        res.setRosterDefinitions(ORBUtility.makeVWRosterDefinitionArray(o.rosterDefinitions));
        res.setDeletedStepProcessorInfoDefinitions(ORBUtility.makeVWStepProcInfoArray(o.deletedStepProcessorDefs));
        res.setAttributes(ORBUtility.makeVWAttributes(o.RegionAttrs));
        res.setMandatoryFieldsIndexesForLogs(ORBUtility.getExposedFieldArray(o.mandatoryLExpFields), ORBUtility.getIndexDefinitionArray(o.mandatoryLIndexes, null));
        res.setMandatoryFieldsIndexesForQueues(ORBUtility.getExposedFieldArray(o.mandatoryQExpFields), ORBUtility.getIndexDefinitionArray(o.mandatoryQIndexes, null));
        res.setMandatoryFieldsIndexesForRosters(ORBUtility.getExposedFieldArray(o.mandatoryRExpFields), ORBUtility.getIndexDefinitionArray(o.mandatoryRIndexes, null));
        res.setApplicationSpaceDefinitions(ORBUtility.makeVWApplicationSpaceDefinitionArray(o.applicationSpaces));
        return res;
    }

    public static VWMilestoneDefinition MilestoneToVWMilestone(MileStoneDefinition msDef) throws VWException {
        VWMilestoneDefinition result = null;
        if (msDef != null) {
            result = VWClassFactory.createVWMilestoneDefinition(msDef.MileStoneName, msDef.MileStoneLevel, msDef.MileStoneMessage, 234L);
        }
        return result;
    }

    public static SystemConfigInfo makeORBConfigFromJavaConfig(VWSystemConfigInfo vwSysCon) throws VWException {
        SystemConfigInfo res = new SystemConfigInfo();
        res.MaxDBOperations = vwSysCon.getMaxDBOperations();
        res.MaxInstructions = vwSysCon.getMaxInstructions();
        res.LoggingState = vwSysCon.getLoggingState();
        res.statsEnabled = vwSysCon.getStatisticsCollection();
        res.TrackAttachmentReferences = vwSysCon.getTrackAttachmentReferences();
        res.DefaultLog = ORBUtility.makeOneORBLogDef(null, null, null);
        res.StepProcessorInfoDefs = ORBUtility.makeORBStepProcDefArray(vwSysCon.getStepProcessorInfoDefinitions());
        res.logDefinitions = ORBUtility.makeORBLogDefArray(vwSysCon.getLogDefinitions(), vwSysCon.getMandatoryIndexesForLogs(), vwSysCon.getMandatoryExposedFieldsForLogs());
        res.queueDefinitions = ORBUtility.makeORBQueueDefArray(vwSysCon.getQueueDefinitions(), vwSysCon.getMandatoryIndexesForQueues(), vwSysCon.getMandatoryExposedFieldsForQueues());
        res.rosterDefinitions = ORBUtility.makeORBRosterDefArray(vwSysCon.getRosterDefinitions(), vwSysCon.getMandatoryIndexesForRosters(), vwSysCon.getMandatoryExposedFieldsForRosters());
        res.mandatoryQIndexes = ORBUtility.makeORBIndexDefArray(null);
        res.mandatoryQExpFields = ORBUtility.makeORBExposedFieldDefArray(null);
        res.mandatoryRIndexes = ORBUtility.makeORBIndexDefArray(null);
        res.mandatoryRExpFields = ORBUtility.makeORBExposedFieldDefArray(null);
        res.mandatoryLIndexes = ORBUtility.makeORBIndexDefArray(null);
        res.mandatoryLExpFields = ORBUtility.makeORBExposedFieldDefArray(null);
        res.deletedStepProcessorDefs = ORBUtility.makeORBStepProcDefArray(vwSysCon.getDeletedStepProcessorInfoDefinitions());
        res.RegionAttrs = ORBUtility.makeORBAttributes(vwSysCon.getAttributes());
        res.callStats = new byte[0];
        res.applicationSpaces = ORBUtility.makeORBApplicationSpaceInfoArray(vwSysCon.getApplicationSpaceDefinitions());
        return res;
    }

    private static StringAndFValue[] makeORBAttributes(Hashtable attrHT) throws VWException {
        StringAndFValue[] res = null;
        if (attrHT != null && attrHT.size() > 0) {
            res = new StringAndFValue[attrHT.size()];
            Enumeration keys = attrHT.keys();
            int i = 0;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object value = attrHT.get(key);
                res[i] = new StringAndFValue();
                res[i].s = key;
                res[i].v = ORBUtility.ObjectToFValue(VWFieldType.getVWFieldType(value), value);
                ++i;
            }
        } else {
            res = new StringAndFValue[]{};
        }
        return res;
    }

    private static StringAndLong[] makeORBStringAndLongArray(Hashtable theHT) throws VWException {
        StringAndLong[] res = null;
        if (theHT != null && theHT.size() > 0) {
            res = new StringAndLong[theHT.size()];
            Enumeration keys = theHT.keys();
            int i = 0;
            while (keys.hasMoreElements()) {
                int key = (Integer)keys.nextElement();
                String value = (String)theHT.get(new Integer(key));
                res[i] = new StringAndLong();
                res[i].l = key;
                res[i].s = value;
                ++i;
            }
        } else {
            res = new StringAndLong[]{};
        }
        return res;
    }

    private static VWIndexDefinition[] stripIndexes(VWIndexDefinition[] IDefs, VWIndexDefinition[] SDefs) throws VWException {
        if (SDefs == null || SDefs.length == 0) {
            return IDefs;
        }
        if (IDefs == null) {
            return null;
        }
        Vector<VWIndexDefinition> inx = new Vector<VWIndexDefinition>();
        VWIndexDefinition[] res = null;
        int countInx = IDefs.length;
        int countSInx = SDefs.length;
        int nIDefs = countInx - countSInx;
        if (nIDefs < 0) {
            nIDefs = 0;
        }
        res = new VWIndexDefinition[nIDefs];
        String name = null;
        boolean found = false;
        for (int i = 0; i < countInx; ++i) {
            name = IDefs[i].getName();
            for (int j = 0; j < countSInx; ++j) {
                if (!name.equals(SDefs[j].getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                inx.add(IDefs[i]);
                continue;
            }
            found = false;
        }
        res = inx.toArray(new VWIndexDefinition[0]);
        return res;
    }

    private static VWExposedFieldDefinition[] stripExposedFields(VWExposedFieldDefinition[] EDefs, VWExposedFieldDefinition[] SDefs) throws VWException {
        if (SDefs == null || SDefs.length == 0) {
            return EDefs;
        }
        if (EDefs == null) {
            return null;
        }
        Vector<VWExposedFieldDefinition> exp = new Vector<VWExposedFieldDefinition>();
        VWExposedFieldDefinition[] res = null;
        int countEx = EDefs.length;
        int countSEx = SDefs.length;
        int nEDefs = countEx - countSEx;
        if (nEDefs < 0) {
            nEDefs = 0;
        }
        res = new VWExposedFieldDefinition[nEDefs];
        String name = null;
        boolean found = false;
        for (int i = 0; i < countEx; ++i) {
            name = EDefs[i].getName();
            for (int j = 0; j < countSEx; ++j) {
                if (!name.equals(SDefs[j].getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                exp.add(EDefs[i]);
                continue;
            }
            found = false;
        }
        res = exp.toArray(new VWExposedFieldDefinition[0]);
        return res;
    }

    private static LogDefinition makeOneORBLogDef(VWLogDefinition LDef, VWIndexDefinition[] IDefs, VWExposedFieldDefinition[] EFDefs) throws VWException {
        LogDefinition res = null;
        if (LDef != null) {
            res = new LogDefinition();
            res.description = ORBUtility.nonNullString(LDef.getDescription());
            VWExposedFieldDefinition[] exFields = ORBUtility.stripExposedFields(LDef.getFields(), EFDefs);
            VWIndexDefinition[] indexDefs = ORBUtility.stripIndexes(LDef.getIndexes(), IDefs);
            res.exposedFields = ORBUtility.makeORBExposedFieldDefArray(exFields);
            res.indexes = ORBUtility.makeORBIndexDefArray(indexDefs);
            res.name = ORBUtility.nonNullString(LDef.getName());
            res.attributes = new StringAndFValue[0];
        } else {
            res = new LogDefinition("", "", new ExposedFieldDefinition[0], new IndexDefinition[0], new StringAndFValue[0]);
        }
        return res;
    }

    private static LogDefinition[] makeORBLogDefArray(VWLogDefinition[] LDefs, VWIndexDefinition[] IDefs, VWExposedFieldDefinition[] EFDefs) throws VWException {
        LogDefinition[] res = null;
        int nLDefs = LDefs == null ? 0 : LDefs.length;
        res = new LogDefinition[nLDefs];
        for (int i = 0; i < nLDefs; ++i) {
            res[i] = ORBUtility.makeOneORBLogDef(LDefs[i], IDefs, EFDefs);
        }
        return res;
    }

    private static StepProcessorInfo makeOneORBStepProcDef(VWStepProcessorInfoDefinition SPDef) throws VWException {
        StepProcessorInfo res = null;
        if (SPDef != null) {
            res = new StepProcessorInfo();
            res.AppType = SPDef.getAppType();
            res.Locations = ORBUtility.makeORBStringAndLongArray(SPDef.getLocations());
            res.Name = ORBUtility.nonNullString(SPDef.getName());
            res.ProcessorType = SPDef.getProcessorType() | SPDef.getAppType();
            res.id = SPDef.getId();
            res.appName = ORBUtility.nonNullString(SPDef.getApplicationName());
            res.height = SPDef.getHeight();
            res.width = SPDef.getWidth();
        } else {
            res = new StepProcessorInfo(0, 0, "", 0, new StringAndLong[0], 0, 0, "");
        }
        return res;
    }

    private static StepProcessorInfo[] makeORBStepProcDefArray(VWStepProcessorInfoDefinition[] SDefs) throws VWException {
        StepProcessorInfo[] res = null;
        int nSDefs = SDefs == null ? 0 : SDefs.length;
        res = new StepProcessorInfo[nSDefs];
        for (int i = 0; i < nSDefs; ++i) {
            res[i] = ORBUtility.makeOneORBStepProcDef(SDefs[i]);
        }
        return res;
    }

    private static QueueDefinition makeOneORBQueueDef(VWQueueDefinition QDef, VWIndexDefinition[] IDefs, VWExposedFieldDefinition[] EFDefs) throws VWException {
        QueueDefinition res = null;
        if (QDef != null) {
            res = new QueueDefinition();
            res.isConnectorQueue = QDef.getIsConnectorQueue();
            res.name = ORBUtility.nonNullString(QDef.getName());
            res.operations = ORBUtility.makeORBOperationDefArray(QDef.getOperations());
            res.queueType = QDef.getQueueType();
            res.readSecurityPx = ORBUtility.makeORBParticipantArray(QDef.getReadSecurity());
            res.description = ORBUtility.nonNullString(QDef.getDescription());
            VWExposedFieldDefinition[] exFields = ORBUtility.stripExposedFields(QDef.getFields(), EFDefs);
            VWIndexDefinition[] indexDefs = ORBUtility.stripIndexes(QDef.getIndexes(), IDefs);
            res.exposedFields = ORBUtility.makeORBExposedFieldDefArray(exFields);
            res.indexes = ORBUtility.makeORBIndexDefArray(indexDefs);
            res.logicalName = ORBUtility.nonNullString(VWClassFactory.VWQueueDefinition_getLogicalName(QDef, 234L));
            res.writeSecurityPx = ORBUtility.makeORBParticipantArray(QDef.getWriteSecurity());
            res.attributes = ORBUtility.VWAttributetoOrbStringFValue(QDef.getAttributeInfo());
            res.serverid = QDef.getServerId();
            res.workBaskets = ORBUtility.makeORBWorkBasketDefinitionArray(QDef.getWorkBasketDefinitions());
        } else {
            res = new QueueDefinition("", "", new ExposedFieldDefinition[0], new IndexDefinition[0], new StringAndFValue[0], new ParticipantStruct[0], new ParticipantStruct[0], 1, false, "", new OperationDefinition[0], 0, new WorkBasketDefinition[0]);
        }
        return res;
    }

    private static QueueDefinition[] makeORBQueueDefArray(VWQueueDefinition[] QDefs, VWIndexDefinition[] IDefs, VWExposedFieldDefinition[] EFDefs) throws VWException {
        QueueDefinition[] res = null;
        int nQDefs = QDefs == null ? 0 : QDefs.length;
        res = new QueueDefinition[nQDefs];
        for (int i = 0; i < nQDefs; ++i) {
            res[i] = ORBUtility.makeOneORBQueueDef(QDefs[i], IDefs, EFDefs);
        }
        return res;
    }

    private static RosterDefinition makeOneORBRosterDef(VWRosterDefinition RDef, VWIndexDefinition[] IDefs, VWExposedFieldDefinition[] EFDefs) throws VWException {
        RosterDefinition res = null;
        if (RDef != null) {
            res = new RosterDefinition();
            res.createSecurityPx = ORBUtility.makeORBParticipantArray(RDef.getCreateSecurity());
            res.description = ORBUtility.nonNullString(RDef.getDescription());
            VWExposedFieldDefinition[] exFields = ORBUtility.stripExposedFields(RDef.getFields(), EFDefs);
            VWIndexDefinition[] indexDefs = ORBUtility.stripIndexes(RDef.getIndexes(), IDefs);
            res.exposedFields = ORBUtility.makeORBExposedFieldDefArray(exFields);
            res.indexes = ORBUtility.makeORBIndexDefArray(indexDefs);
            res.name = ORBUtility.nonNullString(RDef.getName());
            res.readSecurityPx = ORBUtility.makeORBParticipantArray(RDef.getReadSecurity());
            res.writeSecurityPx = ORBUtility.makeORBParticipantArray(RDef.getWriteSecurity());
            res.attributes = new StringAndFValue[0];
            res.serverid = 0;
        } else {
            res = new RosterDefinition("", "", new ExposedFieldDefinition[0], new IndexDefinition[0], new StringAndFValue[0], new ParticipantStruct[0], new ParticipantStruct[0], new ParticipantStruct[0], 0);
        }
        return res;
    }

    private static RosterDefinition[] makeORBRosterDefArray(VWRosterDefinition[] RDefs, VWIndexDefinition[] IDefs, VWExposedFieldDefinition[] EFDefs) throws VWException {
        RosterDefinition[] res = null;
        int nRDefs = RDefs == null ? 0 : RDefs.length;
        res = new RosterDefinition[nRDefs];
        for (int i = 0; i < nRDefs; ++i) {
            res[i] = ORBUtility.makeOneORBRosterDef(RDefs[i], IDefs, EFDefs);
        }
        return res;
    }

    private static IndexDefinition makeOneORBIndexDef(VWIndexDefinition IDef) throws VWException {
        IndexDefinition res = null;
        if (IDef != null) {
            res = new IndexDefinition();
            res.fieldNames = IDef.getFieldNames() != null ? IDef.getFieldNames() : new String[]{};
            res.indexName = ORBUtility.nonNullString(IDef.getName());
            res.isMandatorySystemIndex = false;
            res.isSystemIndex = false;
        } else {
            res = new IndexDefinition("", new String[0], false, false);
        }
        return res;
    }

    private static IndexDefinition[] makeORBIndexDefArray(VWIndexDefinition[] IDefs) throws VWException {
        IndexDefinition[] res = null;
        int nIDefs = IDefs == null ? 0 : IDefs.length;
        res = new IndexDefinition[nIDefs];
        for (int i = 0; i < nIDefs; ++i) {
            res[i] = ORBUtility.makeOneORBIndexDef(IDefs[i]);
        }
        return res;
    }

    private static ExposedFieldDefinition makeOneORBExposedFieldDef(VWExposedFieldDefinition EFDef) throws VWException {
        ExposedFieldDefinition res = null;
        if (EFDef != null) {
            res = new ExposedFieldDefinition();
            res.fieldName = ORBUtility.nonNullString(EFDef.getName());
            res.isMandatorySystemField = false;
            res.length = EFDef.getLength();
            res.sourceName = ORBUtility.nonNullString(EFDef.getSourceName());
            res.sourceType = EFDef.getFieldSourceType();
            res.type = EFDef.getFieldType();
            res.prompt = ORBUtility.nonNullString(EFDef.getPrompt());
        } else {
            res = new ExposedFieldDefinition("", 2, 0, false, false, "", 2, "");
        }
        return res;
    }

    private static ExposedFieldDefinition[] makeORBExposedFieldDefArray(VWExposedFieldDefinition[] EFDefs) throws VWException {
        ExposedFieldDefinition[] res = null;
        int nEFDefs = EFDefs == null ? 0 : EFDefs.length;
        res = new ExposedFieldDefinition[nEFDefs];
        for (int i = 0; i < nEFDefs; ++i) {
            res[i] = ORBUtility.makeOneORBExposedFieldDef(EFDefs[i]);
        }
        return res;
    }

    private static WorkBasketFilterDefinition makeOneORBWorkBasketFilterDefinition(VWWorkBasketFilterDefinition vwWBFilterDef) throws VWException {
        WorkBasketFilterDefinition res = null;
        res = vwWBFilterDef == null ? new WorkBasketFilterDefinition("", "", "", 0, 0, new ExposedFieldDefinition("", 2, 0, false, false, "", 2, ""), 0, new StringAndFValue[0]) : new WorkBasketFilterDefinition(ORBUtility.nonNullString(vwWBFilterDef.getName()), ORBUtility.nonNullString(vwWBFilterDef.getDescription()), ORBUtility.nonNullString(vwWBFilterDef.getPrompt()), 0, 0, ORBUtility.makeOneORBExposedFieldDef(vwWBFilterDef.getSearchField()), vwWBFilterDef.getOperator(), ORBUtility.VWAttributetoOrbStringFValue(vwWBFilterDef.getAttributeInfo()));
        return res;
    }

    private static WorkBasketFilterDefinition[] makeORBWorkBasketFilterDefinitionArray(VWWorkBasketFilterDefinition[] arr) throws VWException {
        int nItems = arr == null ? 0 : arr.length;
        WorkBasketFilterDefinition[] res = new WorkBasketFilterDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeOneORBWorkBasketFilterDefinition(arr[i]);
        }
        return res;
    }

    private static WorkBasketDefinition makeOneORBWorkBasketDefinition(VWWorkBasketDefinition vwWBDef) throws VWException {
        WorkBasketDefinition res = null;
        res = vwWBDef != null ? new WorkBasketDefinition(ORBUtility.nonNullString(vwWBDef.getName()), ORBUtility.nonNullString(vwWBDef.getDescription()), ORBUtility.nonNullString(vwWBDef.getIndexName()), ORBUtility.nonNullString(vwWBDef.getQueryFilterString()), ORBUtility.makeORBWorkBasketColumnDefinitionArray(vwWBDef.getWorkBasketColumnDefinitions()), ORBUtility.makeORBWorkBasketFilterDefinitionArray(vwWBDef.getWorkBasketFilterDefinitions()), ORBUtility.VWAttributetoOrbStringFValue(VWClassFactory.VWWorkBasketDefinition_getAllAttributes(vwWBDef, 234L)), vwWBDef.getRevision(), ORBUtility.nonNullString(vwWBDef.getQueueName()), vwWBDef.getObjId()) : new WorkBasketDefinition("", "", "", "", new WorkBasketColumnDefinition[0], new WorkBasketFilterDefinition[0], new StringAndFValue[0], -1, "", -1);
        return res;
    }

    private static WorkBasketDefinition[] makeORBWorkBasketDefinitionArray(VWWorkBasketDefinition[] arr) throws VWException {
        int nItems = arr == null ? 0 : arr.length;
        WorkBasketDefinition[] res = new WorkBasketDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeOneORBWorkBasketDefinition(arr[i]);
        }
        return res;
    }

    private static OperationDefinition makeOneORBOperationDef(VWOperationDefinition OpDef) throws VWException {
        OperationDefinition res = null;
        if (OpDef != null) {
            res = new OperationDefinition();
            res.description = ORBUtility.nonNullString(OpDef.getDescription());
            res.name = ORBUtility.nonNullString(OpDef.getName());
            res.parameters = ORBUtility.makeORBParameterArray(OpDef.getParameterDefinitions());
            res.attributes = ORBUtility.VWAttributetoOrbStringFValue(OpDef.getAttributeInfo());
        } else {
            res = new OperationDefinition("", "", new Field[0], new StringAndFValue[0]);
        }
        return res;
    }

    private static OperationDefinition[] makeORBOperationDefArray(VWOperationDefinition[] OpDefs) throws VWException {
        OperationDefinition[] res = null;
        int nOpDefs = OpDefs == null ? 0 : OpDefs.length;
        res = new OperationDefinition[nOpDefs];
        for (int i = 0; i < nOpDefs; ++i) {
            res[i] = ORBUtility.makeOneORBOperationDef(OpDefs[i]);
        }
        return res;
    }

    private static ParticipantStruct makeOneORBParticipant(String PDef) throws VWException {
        ParticipantStruct res = null;
        if (PDef != null) {
            res = new ParticipantStruct();
            res.displayName = "";
            res.shortName = ORBUtility.nonNullString(PDef);
            res.usrId = 0;
            res.realm = "";
            res.dn = "";
            res.objectClass = false;
        } else {
            res = new ParticipantStruct("", "", 0, "", false, "");
        }
        return res;
    }

    private static ParticipantStruct[] makeORBParticipantArray(String[] PDefs) throws VWException {
        int i;
        ParticipantStruct[] res = null;
        int nPDefs = PDefs == null ? 0 : PDefs.length;
        int realCnt = 0;
        for (i = 0; i < nPDefs; ++i) {
            if (PDefs[i] == null || PDefs[i].length() <= 0) continue;
            ++realCnt;
        }
        res = new ParticipantStruct[realCnt];
        for (i = 0; i < realCnt; ++i) {
            res[i] = ORBUtility.makeOneORBParticipant(PDefs[i]);
        }
        return res;
    }

    private static Field makeOneORBParameterDef(VWParameterDefinition PDef) throws VWException {
        Field res = null;
        if (PDef != null) {
            res = new Field();
            res.altered = false;
            res.displayString = ORBUtility.nonNullString(PDef.getDescription());
            res.fieldType = PDef.getDataType();
            res.hasBeenAlteredArray = new boolean[0];
            res.isArray = PDef.getIsArray();
            res.isSystemField = false;
            res.mode = PDef.getMode();
            res.name = ORBUtility.nonNullString(PDef.getName());
            res.value = ORBUtility.ObjectToFValue(VWFieldType.getVWFieldType(PDef.getValue()), PDef.getValue());
            res.requiredGUID = ORBUtility.nonNullString("");
        } else {
            res = new Field("", new FValue(), 2, false, false, 1, false, new boolean[0], "", "");
        }
        return res;
    }

    private static Field[] makeORBParameterArray(VWParameterDefinition[] PDefs) throws VWException {
        Field[] res = null;
        int nFields = PDefs == null ? 0 : PDefs.length;
        res = new Field[nFields];
        for (int i = 0; i < nFields; ++i) {
            res[i] = ORBUtility.makeOneORBParameterDef(PDefs[i]);
        }
        return res;
    }

    private static String nonNullString(String x) {
        return x == null ? "" : x;
    }

    private static VWWorkBasketDefinition[] makeVWWorkBasketDefinitions(WorkBasketDefinition[] oArr, VWQueueDefinition qdef) throws VWException {
        int nWBs = oArr == null ? 0 : oArr.length;
        VWWorkBasketDefinition[] res = new VWWorkBasketDefinition[nWBs];
        for (int i = 0; i < nWBs; ++i) {
            WorkBasketDefinition wbDef = oArr[i];
            res[i] = VWClassFactory.createVWWorkBasketDefinition(wbDef.revision, wbDef.name, wbDef.description, wbDef.indexName, wbDef.queueQueryFilter, ORBUtility.makeVWWorkBasketColumnDefinitionArray(wbDef.columns, false), ORBUtility.makeVWWorkBasketFilterDefinitionArray(wbDef.adHocFilters, false), VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(wbDef.attributes), 234L), qdef, wbDef.qName, wbDef.objId, 234L);
        }
        return res;
    }

    protected static VWApplicationSpaceDefinition makeVWApplicationSpaceDefinition(ApplicationSpaceInfo res) throws VWException {
        VWApplicationSpaceDefinition asdef = null;
        if (res != null) {
            if (res.name == null || res.name.length() == 0) {
                return null;
            }
            asdef = VWClassFactory.createVWApplicationSpaceDefinition(res.revision, res.name, res.description, res.objId, 234L);
            asdef.setAttributeInfo(VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(res.attributes), 234L));
            asdef.setWriteSecurityPx(ORBUtility.ParticipantArrayToVWParticipantArray(res.writeSecurityPx));
            int nRoles = res.roles == null ? 0 : res.roles.length;
            for (int i = 0; i < nRoles; ++i) {
                RoleDefinitionInfo orbRole = res.roles[i];
                VWRoleDefinition roleDef = VWClassFactory.createVWRoleDefinition(orbRole.revision == 0 ? 1 : orbRole.revision, orbRole.name, asdef, orbRole.objId, ORBUtility.makeVWWorkBasketRefArray(orbRole.workBaskets), 234L);
                roleDef.setAttributeInfo(VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(res.roles[i].attributes), 234L));
                roleDef.setHomePageURL(res.roles[i].homePageURL);
                roleDef.setDescription(res.roles[i].description);
                VWClassFactory.VWRoleDefinition_setHasChanged(roleDef, false, 234L);
            }
            VWClassFactory.VWApplicationSpaceDefinition_setHasChanged(asdef, false, 234L);
        }
        return asdef;
    }

    private static WorkBasketRef[] makeVWWorkBasketRefArray(filenet.pe.peorb.FileNet_PERPC.WorkBasketRef[] orbWBRefArr) {
        int nItems = orbWBRefArr == null ? 0 : orbWBRefArr.length;
        WorkBasketRef[] res = new WorkBasketRef[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = orbWBRefArr[i] != null ? new WorkBasketRef(orbWBRefArr[i].queueName, orbWBRefArr[i].workBasketName) : null;
        }
        return res;
    }

    private static filenet.pe.peorb.FileNet_PERPC.WorkBasketRef[] makeORBWorkBasketRefArray(VWWorkBasketDefinition[] vwWBDefArr) throws VWException {
        int nItems = vwWBDefArr == null ? 0 : vwWBDefArr.length;
        filenet.pe.peorb.FileNet_PERPC.WorkBasketRef[] res = new filenet.pe.peorb.FileNet_PERPC.WorkBasketRef[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = vwWBDefArr[i] != null ? new filenet.pe.peorb.FileNet_PERPC.WorkBasketRef(ORBUtility.nonNullString(vwWBDefArr[i].getQueueName()), ORBUtility.nonNullString(vwWBDefArr[i].getName())) : new filenet.pe.peorb.FileNet_PERPC.WorkBasketRef("", "");
        }
        return res;
    }

    private static VWApplicationSpaceDefinition[] makeVWApplicationSpaceDefinitionArray(ApplicationSpaceInfo[] oArr) throws VWException {
        int nItems;
        int n = nItems = oArr == null ? 0 : oArr.length;
        if (nItems == 0) {
            return null;
        }
        VWApplicationSpaceDefinition[] res = new VWApplicationSpaceDefinition[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeVWApplicationSpaceDefinition(oArr[i]);
        }
        return res;
    }

    private static ApplicationSpaceInfo makeOneORBAppicationSpaceInfo(VWApplicationSpaceDefinition asDef) throws VWException {
        ApplicationSpaceInfo res = null;
        res = asDef != null ? new ApplicationSpaceInfo(ORBUtility.nonNullString(asDef.getName()), ORBUtility.nonNullString(asDef.getDescription()), new ParticipantStruct[0], ORBUtility.makeORBParticipantArray(asDef.getWriteSecurity()), ORBUtility.makeORBRoleDefinitionInfoArray(asDef.getRoleDefinitions()), ORBUtility.makeORBRoleDefinitionInfoArray(VWClassFactory.VWApplicationSpaceDefinition_getDeletedRoles(asDef, 234L)), ORBUtility.VWAttributetoOrbStringFValue(asDef.getAttributeInfo()), asDef.getRevision(), asDef.getObjId()) : new ApplicationSpaceInfo("", "", new ParticipantStruct[0], new ParticipantStruct[0], new RoleDefinitionInfo[0], new RoleDefinitionInfo[0], new StringAndFValue[0], -1, 0);
        return res;
    }

    private static ApplicationSpaceInfo[] makeORBApplicationSpaceInfoArray(VWApplicationSpaceDefinition[] asDefs) throws VWException {
        ApplicationSpaceInfo[] res = null;
        int nDefs = asDefs == null ? 0 : asDefs.length;
        res = new ApplicationSpaceInfo[nDefs];
        for (int i = 0; i < nDefs; ++i) {
            res[i] = ORBUtility.makeOneORBAppicationSpaceInfo(asDefs[i]);
        }
        return res;
    }

    private static RoleDefinitionInfo makeOneORBRoleDefinitionInfo(VWRoleDefinition roleDef) throws VWException {
        RoleDefinitionInfo res = null;
        if (roleDef != null) {
            boolean roleParticipantModified = roleDef.hasRoleParticipantsChanged();
            res = new RoleDefinitionInfo(ORBUtility.nonNullString(roleDef.getName()), ORBUtility.nonNullString(roleDef.getDescription()), ORBUtility.nonNullString(roleDef.getHomePageURL()), ORBUtility.VWAttributetoOrbStringFValue(roleDef.getAttributeInfo()), ORBUtility.makeORBWorkBasketRefArray(roleDef.getWorkBasketDefinitions()), roleParticipantModified, roleParticipantModified ? ORBUtility.makeORBParticipantArray(roleDef.getRoleParticipantNames()) : new ParticipantStruct[]{}, roleDef.getRevision(), roleDef.getObjId());
        } else {
            res = new RoleDefinitionInfo("", "", "", new StringAndFValue[0], new filenet.pe.peorb.FileNet_PERPC.WorkBasketRef[0], false, new ParticipantStruct[0], -1, 0);
        }
        return res;
    }

    private static RoleDefinitionInfo[] makeORBRoleDefinitionInfoArray(VWRoleDefinition[] roleDefs) throws VWException {
        RoleDefinitionInfo[] res = null;
        int nDefs = roleDefs == null ? 0 : roleDefs.length;
        res = new RoleDefinitionInfo[nDefs];
        for (int i = 0; i < nDefs; ++i) {
            res[i] = ORBUtility.makeOneORBRoleDefinitionInfo(roleDefs[i]);
        }
        return res;
    }

    protected static VWRole RoleDefinitionToVWRole(RoleDefinitionInfo r, String appSpaceName) throws VWException {
        if (r == null) {
            return null;
        }
        VWParticipant[] pArr = ORBUtility.ParticipantArrayToVWParticipantArray(r.participants);
        return VWClassFactory.createVWRole(r.revision, r.name, r.description, r.homePageURL, VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(r.attributes), 234L), appSpaceName, ORBUtility.makeVWWorkBasketRefArray(r.workBaskets), r.objId, pArr, 234L);
    }

    protected static VWRole RoleToVWRole(Role r) throws VWException {
        if (r == null) {
            return null;
        }
        return VWClassFactory.createVWRole(r.revision, r.name, r.description, r.homePageURL, VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(r.attributes), 234L), r.appSpaceName, ORBUtility.makeVWWorkBasketRefArray(r.workBaskets), r.objId, 234L);
    }

    protected static VWRole[] RoleArrayToVWRoleArray(Role[] rArr) throws VWException {
        if (rArr == null) {
            return null;
        }
        int nRoles = rArr.length;
        VWRole[] res = new VWRole[nRoles];
        for (int i = 0; i < nRoles; ++i) {
            res[i] = ORBUtility.RoleToVWRole(rArr[i]);
        }
        return res;
    }

    protected static InternalVWWorkBasket makeInternalVWWorkBasket(WorkBasket wb) throws VWException {
        if (wb == null) {
            return null;
        }
        WorkBasketDefinition wbDef = wb.workBasketDef;
        return new InternalVWWorkBasket(VWClassFactory.createVWWorkBasketDefinition(wbDef.revision, wbDef.name, wbDef.description, wbDef.indexName, wbDef.queueQueryFilter, ORBUtility.makeVWWorkBasketColumnDefinitionArray(wbDef.columns, true), ORBUtility.makeVWWorkBasketFilterDefinitionArray(wbDef.adHocFilters, true), VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(wbDef.attributes), 234L), null, wbDef.qName, wbDef.objId, 234L));
    }

    protected static InternalVWWorkBasket[] makeInternalVWWorkBasketArray(WorkBasket[] oArr) throws VWException {
        if (oArr == null) {
            return null;
        }
        int nItems = oArr.length;
        InternalVWWorkBasket[] res = new InternalVWWorkBasket[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = ORBUtility.makeInternalVWWorkBasket(oArr[i]);
        }
        return res;
    }

    protected static VWApplicationSpace[] appSpaceInfoArrayToVWAppSpaceArray(ApplicationSpaceInfo[] appSpaceInfoArray) throws VWException {
        VWApplicationSpace[] result = null;
        if (appSpaceInfoArray != null) {
            result = new VWApplicationSpace[appSpaceInfoArray.length];
            for (int i = 0; i < appSpaceInfoArray.length; ++i) {
                result[i] = ORBUtility.appSpaceInfoToVWAppSpace(appSpaceInfoArray[i]);
            }
        }
        return result;
    }

    protected static VWApplicationSpace appSpaceInfoToVWAppSpace(ApplicationSpaceInfo appSpaceInfo) throws VWException {
        try {
            VWAttributeInfo attributes = VWClassFactory.createVWAttributeInfo(ORBUtility.makeVWAttributes(appSpaceInfo.attributes), 234L);
            VWRole[] roles = null;
            if (appSpaceInfo.roles != null) {
                roles = new VWRole[appSpaceInfo.roles.length];
                for (int i = 0; i < appSpaceInfo.roles.length; ++i) {
                    roles[i] = ORBUtility.RoleDefinitionToVWRole(appSpaceInfo.roles[i], appSpaceInfo.name);
                }
            }
            VWApplicationSpace result = VWClassFactory.createVWApplicationSpace(appSpaceInfo.revision, appSpaceInfo.name, appSpaceInfo.description, attributes, appSpaceInfo.objId, roles, 234L);
            return result;
        }
        catch (Exception ex) {
            String m_method = "AppSpaceInfoToVWAppSpace:" + (appSpaceInfo == null ? "NULL" : appSpaceInfo.name) + "," + (appSpaceInfo == null ? "0" : Integer.toString(appSpaceInfo.objId));
            exceptionLogger.throwing(m_className, m_method, ex);
            throw new VWException(ex);
        }
    }
}

